-- MOD per DCS WORLD 
-- Corazzata Italiana WWII "Iowa"  by Markindel and Cadarth
-- Italian BattleShip WWII Iowa
-----             Cartella Shapes --------------------------------------------------
mount_vfs_model_path	(current_mod_path.."/Shapes/")

-----             Cartella Textures ---------------------------------------------------
mount_vfs_texture_path  (current_mod_path.."/Textures/Vought_KingFisher.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/USS_Iowa.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/")


-----             Cartella Sound --------------------------------------------------
--mount_vfs_model_path	(current_mod_path.."/Sound/")
--mount_vfs_model_path	(current_mod_path.."/Sound/Effects")
--mount_vfs_model_path	(current_mod_path.."/Sound/Effects/Weapons")


GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "missouri"
GT.visual.shape_dstr = ""

---------------------------------------------------------------------
----------------------------------------------------------------------

GT.animation_arguments.radar1_rotation = 11; --   1
GT.radar1_period = 3;
GT.animation_arguments.radar2_rotation = -1; --   2 
GT.animation_arguments.radar3_rotation = -1; --   3 
GT.animation_arguments.luna_lights = -1;


GT.life = 6000
GT.mass = 7.25e+006
GT.max_velocity = 61
GT.race_velocity = 40
GT.economy_velocity = 30
GT.economy_distance = 1.59272e+007
GT.race_distance = 1.59272e+007
GT.shipLength = 251
GT.Width = 36
GT.Height = 25.6
GT.Length = 106.2
GT.DeckLevel = 7.2

GT.X_nose = 130.612
GT.X_tail = -110.397

GT.Tail_Width = 11
GT.Gamma_max = 0.35
GT.Om = 0.05
GT.speedup = 0.1
GT.R_min = 212.4
GT.distFindObstacles = 368.6

GT.airWeaponDist = 10000  --- edited by baco30 was 100000
GT.airFindDist = 20000    --- was 150000
GT.exhaust = 
{
--	[1] = { size = 0.90 , pos = {1.0 , 26.0, 1.0 } },
	[1] = { size = 0.90 , pos = {-4.333 , 29.364, 0.0 } },
}


---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra

GT.DM = {
----- Scafo.
	{ area_name = "Scafo_Prua_Dx",			area_arg = 76,	area_life = 100, area_fire = { pos = {75.0, 4.0, 8.0}, size = 1.5}},
	{ area_name = "Scafo_Centrale_Dx",		area_arg = 71,	area_life = 100, area_fire = { pos = {20.0,  2.0, 13.0}, size = 1.5}},
	{ area_name = "Scafo_Poppa_Dx", 		area_arg = 72,	area_life = 100, area_fire = { pos = {-70.0, 2.0, 8.0}, size = 1.5}},
	{ area_name = "Scafo_Prua_Sx", 		    area_arg = 73,	area_life = 100, area_fire = { pos = {90.0, 4.0, -10.0}, size = 1.5}},
	{ area_name = "Scafo_Centrale_Sx", 		area_arg = 74,	area_life = 100, area_fire = { pos = {0.0,  2.0, -13.0}, size = 1.5}},
	{ area_name = "Scafo_Poppa_Sx", 		area_arg = 75,	area_life = 100, area_fire = { pos = {-100.0, 2.0, -10.5}, size = 1.5}},
-------- Sovrastrutture	
	{ area_name = "Zona_Fumaiolo",          area_arg = 77,	area_life = 60,  area_fire = { pos = {0.5, 12.0, 0.0}, size = 2.5}},
	{ area_name = "Strutture_Poppa",        area_arg = 82,	area_life = 200, area_fire = { pos = {-23.0, 12.0, 0.0}, size = 1.5}},
	{ area_name = "Sala_Comando",	        area_arg = 83,	area_life = 150, area_fire = { pos = {15.0, 12.0, 0.0}, size = 2.5}},
		
--------- 4 Torri Binate da 380mm	
	{ area_name = "Torre_380_Anton",		area_arg = 96,	area_life = 60, area_fire = { pos = {55.0, 11.0, 0.0}, size =  1.5}},
	{ area_name = "Torre_380_Bruno",		area_arg = 98,	area_life = 60, area_fire = { pos = {35.0, 14.0, 0.0}, size =  1.5}},  
	{ area_name = "Torre_380_Cesare",		area_arg = 70,	area_life = 60, area_fire = { pos = {-64.0, 14.0, 0.0}, size = 1.5}},
	{ area_name = "Torre_380_Dora",		    area_arg = 99,	area_life = 60, area_fire = { pos = {-62.0, 11.0, 0.0}, size = 1.5}},  

	{ area_name = "Ponte Prua",	           	area_arg = 84,	area_life = 60, area_fire = { pos = {67.0, 11.0, 0.0}, size =  1.5}},
         { area_name = "Ponte Poppa",		area_arg = 85,	area_life = 60, area_fire = { pos = {-95.0, 11.0, 0.0}, size = 1.5}}, 
--[[	
------------------ 6 Torri Binate da 150
	{ area_name = "Torre_150_Dx_1",			area_arg = 71,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
	{ area_name = "Torre_150_Dx_2",			area_arg = 71,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
	{ area_name = "Torre_150_Dx_3",			area_arg = 71,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
	{ area_name = "Torre_150_Sx_1",			area_arg = 74,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
	{ area_name = "Torre_150_Sx_2",			area_arg = 74,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
	{ area_name = "Torre_150_Sx_3",			area_arg = 74,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
--]]
   
--	{ area_name = "NOSE_TOP",		area_arg = 76,	area_life = 80,  area_fire = { pos = {41.5, 7.5, 0.0}, size = 0.5}},
-- 	{ area_name = "KORMA_BACK", 	area_arg = 79,	area_life = 110, area_fire = { pos = {-85.7, 2.0, 0.0}, size = 0.5}},
--	{ area_name = "KABINA",			area_arg = 80,	area_life = 220, area_fire = { pos = {29.0, 15.0, 0.0}, size = 1.5}},
--	{ area_name = "BORT_TOP_Back", 	area_arg = 81,	area_life = 80,  area_fire = { pos = {-62.5, 7.0, 0.0}, size = 0.5}},
--	{ area_name = "KORMA_TOP", 		area_arg = 84,	area_life = 40, area_fire = { pos = {-80.5, 4.2, 0.0}, size = 1.0}},
    
--	{ area_name = "TOWER_NOSE",		area_arg = 97,	area_life = 60, area_fire = { pos = {53.0, 9.0, 0.0}, size = 0.5}},
--	{ area_name = "TOWER_KORMA",	area_arg = 98,	area_life = 60, area_fire = { pos = {-73.5, 5.5, 0.0}, size = 0.5}},
--  { area_name = "ZA_R",			area_arg = 99,	area_life = 27, area_fire = { pos = {3.7, 17.15, 6.25}, size = 0.5}},
--    { area_name = "ZA_L",			area_arg = 100,	area_life = 27, area_fire = { pos = {3.7, 17.15, -6.25}, size = 0.5}},
}



-- Source for modifications: https://en.wikipedia.org/wiki/Littorio-class_battleship
-- https://en.wikipedia.org/wiki/Italian_battleship_Iowa_%281940%29
-- ship_Breda_20/65 (20 mm) naval AAA weapons. Source: https://en.wikipedia.org/wiki/Breda_Model_35
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_Breda_20_65 = {name = "2 cm Breda /65"};
GT_t.WS_t.ship_Breda_20_65.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-10), math.rad(90)},
                    };
GT_t.WS_t.ship_Breda_20_65.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_Breda_20_65.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_Breda_20_65.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Breda_20_65.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Breda_20_65.reference_angle_Z = 0
GT_t.WS_t.ship_Breda_20_65.LN = {}
GT_t.WS_t.ship_Breda_20_65.LN[1] = {}
GT_t.WS_t.ship_Breda_20_65.LN[1].type = 3
GT_t.WS_t.ship_Breda_20_65.LN[1].distanceMin = 10
GT_t.WS_t.ship_Breda_20_65.LN[1].distanceMax = 1500 -- effective shooting with 3600 meters
GT_t.WS_t.ship_Breda_20_65.LN[1].max_trg_alt = 1000
GT_t.WS_t.ship_Breda_20_65.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_Breda_20_65.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_Breda_20_65.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_Breda_20_65.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_Breda_20_65.LN[1].PL = {}
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1] = {}
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1].ammo_capacity = 1550;
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1].shell_name = {"Rh202_20_AP", "Rh202_20_HE"};
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1].shell_display_name = "20mm AP+HE";
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1].shot_delay = 60/240 -- 240 rounds per minute average
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_Breda_20_65.LN[1].BR = { {pos = {3.478, 0, 0} }, }

-- ship_Breda_37/54 (37 mm) naval AAA weapons. Source: https://en.wikipedia.org/wiki/Cannone-Mitragliera_da_37/54_%28Breda%29
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_Breda_37_54 = {name = "3.7 cm Breda /54"};
GT_t.WS_t.ship_Breda_37_54.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-10), math.rad(80)},
                    };
GT_t.WS_t.ship_Breda_37_54.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_Breda_37_54.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_Breda_37_54.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Breda_37_54.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Breda_37_54.reference_angle_Z = 0
GT_t.WS_t.ship_Breda_37_54.LN = {}
GT_t.WS_t.ship_Breda_37_54.LN[1] = {}
GT_t.WS_t.ship_Breda_37_54.LN[1].type = 3
GT_t.WS_t.ship_Breda_37_54.LN[1].distanceMin = 10
GT_t.WS_t.ship_Breda_37_54.LN[1].distanceMax = 7800 -- effective shooting
GT_t.WS_t.ship_Breda_37_54.LN[1].max_trg_alt = 4000
GT_t.WS_t.ship_Breda_37_54.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_Breda_37_54.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_Breda_37_54.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_Breda_37_54.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_Breda_37_54.LN[1].PL = {}
GT_t.WS_t.ship_Breda_37_54.LN[1].PL[1] = {}
GT_t.WS_t.ship_Breda_37_54.LN[1].PL[1].ammo_capacity = 1550;
GT_t.WS_t.ship_Breda_37_54.LN[1].PL[1].shell_name = {"Breda_37_HE"};
GT_t.WS_t.ship_Breda_37_54.LN[1].PL[1].shell_display_name = "37mm HE";
GT_t.WS_t.ship_Breda_37_54.LN[1].PL[1].shot_delay = 60/120 -- 120 rounds per minute average
GT_t.WS_t.ship_Breda_37_54.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_Breda_37_54.LN[1].BR = { {pos = {3.478, 0, 0} }, }


-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 90mm
-------------------------------------------------------------------------------------------------

-- 90/53 (90 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/Cannone_da_90/53
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_90_53 = {name = "9 cm 90/53"};
GT_t.WS_t.ship_90_53.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-2), math.rad(85)},
                    };
GT_t.WS_t.ship_90_53.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_90_53.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_90_53.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_90_53.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_90_53.reference_angle_Z = 0
GT_t.WS_t.ship_90_53.LN = {}
GT_t.WS_t.ship_90_53.LN[1] = {}
GT_t.WS_t.ship_90_53.LN[1].type = 3
GT_t.WS_t.ship_90_53.LN[1].distanceMin = 10
GT_t.WS_t.ship_90_53.LN[1].distanceMax = 17400 -- effective shooting
GT_t.WS_t.ship_90_53.LN[1].max_trg_alt = 12000 -- effective shooting
GT_t.WS_t.ship_90_53.LN[1].reactionTime = 3
GT_t.WS_t.ship_90_53.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_90_53.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_90_53.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_90_53.LN[1].PL = {}
GT_t.WS_t.ship_90_53.LN[1].PL[1] = {}
GT_t.WS_t.ship_90_53.LN[1].PL[1].ammo_capacity = 240; -- Currently uses same ammo count as SK_C_38
GT_t.WS_t.ship_90_53.LN[1].PL[1].shell_name = {"90_53_HE"};
GT_t.WS_t.ship_90_53.LN[1].PL[1].shell_display_name = "90mm HE";
GT_t.WS_t.ship_90_53.LN[1].PL[1].shot_delay = 60/19; -- (19 rounds per minute per barrel - average)
GT_t.WS_t.ship_90_53.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_90_53.LN[1].PL[1].automaticLoader = false;
GT_t.WS_t.ship_90_53.LN[1].BR = { {pos = {3.478, 0, 0} }, }


-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 152mm
-------------------------------------------------------------------------------------------------
-- 152/55 (152 mm) naval artillery weapons. Source: Currently none.
-- Used default FMC5 MK45 127mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_152_55 = {name = "15 cm 152/55"}
GT_t.WS_t.ship_152_55.angles = {
					{math.rad(135), math.rad(-135), math.rad(-10), math.rad(45)},
					};
GT_t.WS_t.ship_152_55.omegaY = 0.6
GT_t.WS_t.ship_152_55.omegaZ = 0.6
GT_t.WS_t.ship_152_55.reference_angle_Z = 0
GT_t.WS_t.ship_152_55.LN = {}
GT_t.WS_t.ship_152_55.LN[1] = {}
GT_t.WS_t.ship_152_55.LN[1].type = 6
GT_t.WS_t.ship_152_55.LN[1].xc = 3
GT_t.WS_t.ship_152_55.LN[1].distanceMin = 50
GT_t.WS_t.ship_152_55.LN[1].max_trg_alt = 7500
GT_t.WS_t.ship_152_55.LN[1].reactionTime = 15
GT_t.WS_t.ship_152_55.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_152_55.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_152_55.LN[1].PL = {}
GT_t.WS_t.ship_152_55.LN[1].PL[1] = {}
GT_t.WS_t.ship_152_55.LN[1].PL[1].ammo_capacity = 240 -- Currently uses same ammo count as SK_C_38
GT_t.WS_t.ship_152_55.LN[1].PL[1].shell_name = {"MK45_127"}; -- Currently uses MK45 127 mm shells (150 mm ammo is WIP)
GT_t.WS_t.ship_152_55.LN[1].PL[1].shot_delay = 60/4 -- (4 rounds per minute per barrel - average)
GT_t.WS_t.ship_152_55.LN[1].automaticLoader = false;
GT_t.WS_t.ship_152_55.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_152_55.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, 0.0} }, {pos = {8, 0, -0.1} } }


-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 381mm
-------------------------------------------------------------------------------------------------
-- Cannone da 381/50 Ansaldo M1934 (381 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/Cannone_da_381/50_Ansaldo_M1934
-- Used default AK130 130mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_381_50_M1934 = {name = "38.1 cm 381/50 M1934"}
GT_t.WS_t.ship_381_50_M1934.angles = {
					{math.rad(140), math.rad(-140), math.rad(-5.5), math.rad(35)},
					};
GT_t.WS_t.ship_381_50_M1934.omegaY = 0.6
GT_t.WS_t.ship_381_50_M1934.omegaZ = 0.6
GT_t.WS_t.ship_381_50_M1934.reference_angle_Z = 0
GT_t.WS_t.ship_381_50_M1934.LN = {}
GT_t.WS_t.ship_381_50_M1934.LN[1] = {}
GT_t.WS_t.ship_381_50_M1934.LN[1].type = 6
GT_t.WS_t.ship_381_50_M1934.LN[1].distanceMin = 50
GT_t.WS_t.ship_381_50_M1934.LN[1].max_trg_alt = 20
GT_t.WS_t.ship_381_50_M1934.LN[1].reactionTime = 15
GT_t.WS_t.ship_381_50_M1934.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_381_50_M1934.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_381_50_M1934.LN[1].PL = {}
GT_t.WS_t.ship_381_50_M1934.LN[1].PL[1] = {}
GT_t.WS_t.ship_381_50_M1934.LN[1].PL[1].ammo_capacity = 240
GT_t.WS_t.ship_381_50_M1934.LN[1].PL[1].shell_name = {"A222_130"}; -- Currently uses A222 130 mm shells (381 mm ammo is WIP)
--GT_t.WS_t.ship_381_50_M1934.LN[1].PL[1].shell_name = {"Shell_381mm"};

GT_t.WS_t.ship_381_50_M1934.LN[1].PL[1].shot_delay = 60/1.3 -- (1.3 rounds per minute per barrel - 1 per 45 sec average)
GT_t.WS_t.ship_381_50_M1934.LN[1].automaticLoader = false;
GT_t.WS_t.ship_381_50_M1934.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_381_50_M1934.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, 0.0} }, {pos = {8, 0, -0.1} } }

-- weapon systems
GT.WS = {}
local ws;
GT.WS.maxTargetDetectionRange = 450000;
GT.WS.radar_type = 102

-------------------------------------------------------------------------------
-- C:\Program Files\Eagle Dynamics\DCS World OpenBeta\Sounds\Sounders\GroundUnits\WeaponSystem\Navy
-------------------------------------------------------------------------------


-------------------------------------------------------------------------------
--           14   Mitragliatrici Breda Binate  Flak38                -----------
--- Mitragliatrice Binata di Sx 1 - twin machine gun left           -----------
-------------------------------------------------------------------------------
--1
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Centrale_Sx'
GT.WS[ws].center = 'CENTER_TOWER_20'
GT.WS[ws].drawArgument1 = 63
GT.WS[ws].drawArgument2 = 64
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(3);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 155;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_1_1',
		recoilArgument = 155,
	},
	{
		connector_name = 'POINT_Flak38_1_2',
		recoilArgument = 155,
	}
}



--2
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Centrale_Dx'
GT.WS[ws].center = 'CENTER_TOWER_21'
GT.WS[ws].drawArgument1 = 61  ------------ Rotazione
GT.WS[ws].drawArgument2 = 62  ------------ Alzo
GT.WS[ws].angles[1][1] = math.rad(-3);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 154;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_2_1',
		recoilArgument = 154,
	},
	{
		connector_name = 'POINT_Flak38_2_2',
		recoilArgument = 154,
	}
}



--3
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_22'
GT.WS[ws].drawArgument1 = 67
GT.WS[ws].drawArgument2 = 68
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(3);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 157;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_3_1',
		recoilArgument = 157,
	},
	{
		connector_name = 'POINT_Flak38_3_2',
		recoilArgument = 157,
	},
}


--4
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_23'
GT.WS[ws].drawArgument1 = 46
GT.WS[ws].drawArgument2 = 47
GT.WS[ws].angles[1][1] = math.rad(-3);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 48;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_4_1',
		recoilArgument = 48,
	},
	{
		connector_name = 'POINT_Flak38_4_2',
		recoilArgument = 48,
	}
}

--5
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_5'
GT.WS[ws].drawArgument1 = 23
GT.WS[ws].drawArgument2 = 24
GT.WS[ws].angles[1][1] = math.rad(170);
GT.WS[ws].angles[1][2] = math.rad(3);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 38;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_5_1',
		recoilArgument = 38,
	},
	{
		connector_name = 'POINT_Flak38_5_2',
		recoilArgument = 38,
	},
}

--6
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_6'
GT.WS[ws].drawArgument1 = 25
GT.WS[ws].drawArgument2 = 26
GT.WS[ws].angles[1][1] = math.rad(-3);
GT.WS[ws].angles[1][2] = math.rad(-170);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 39;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_6_1',
		recoilArgument = 39,
	},
	{
		connector_name = 'POINT_Flak38_6_2',
		recoilArgument = 39,
	}
}


--7
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_7'
GT.WS[ws].drawArgument1 = 27
GT.WS[ws].drawArgument2 = 28
GT.WS[ws].angles[1][1] = math.rad(170);
GT.WS[ws].angles[1][2] = math.rad(3);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 40;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_7_1',
		recoilArgument = 40,
	},
	{
		connector_name = 'POINT_Flak38_7_2',
		recoilArgument = 40,
	}
}

--8
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_8'
GT.WS[ws].drawArgument1 = 29
GT.WS[ws].drawArgument2 = 30
GT.WS[ws].angles[1][1] = math.rad(-3);
GT.WS[ws].angles[1][2] = math.rad(-170);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 41;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_8_1',
		recoilArgument = 41,
	},
	{
		connector_name = 'POINT_Flak38_8_2',
		recoilArgument = 41,
	}
}


--9
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_9'
GT.WS[ws].drawArgument1 = 19
GT.WS[ws].drawArgument2 = 20
GT.WS[ws].angles[1][1] = math.rad(170);
GT.WS[ws].angles[1][2] = math.rad(3);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 36;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_9_1',
		recoilArgument = 36,
	},
	{
		connector_name = 'POINT_Flak38_9_2',
		recoilArgument = 36,
	}
}

--10
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_10'
GT.WS[ws].drawArgument1 = 21
GT.WS[ws].drawArgument2 = 22
GT.WS[ws].angles[1][1] = math.rad(-3);
GT.WS[ws].angles[1][2] = math.rad(-170);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 37;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_10_1',
		recoilArgument = 37,
	},
	{
		connector_name = 'POINT_Flak38_10_2',
		recoilArgument = 37,
	}
}

--11
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_11'
GT.WS[ws].drawArgument1 = 31
GT.WS[ws].drawArgument2 = 32
GT.WS[ws].angles[1][1] = math.rad(170);
GT.WS[ws].angles[1][2] = math.rad(3);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 42;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_11_1',
		recoilArgument = 42,
	},
	{
		connector_name = 'POINT_Flak38_11_2',
		recoilArgument = 42,
	}
}

--12
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_12'
GT.WS[ws].drawArgument1 = 43
GT.WS[ws].drawArgument2 = 44
GT.WS[ws].angles[1][1] = math.rad(-3);
GT.WS[ws].angles[1][2] = math.rad(-170);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 45;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_12_1',
		recoilArgument = 45,
	},
	{
		connector_name = 'POINT_Flak38_12_2',
		recoilArgument = 45,
	}
}

------------ 2 Postazioni BOFORS situate a poppa --------------
------------ 2 BOFORS machine guns aft           --------------


--13 Left Aft
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_13'
GT.WS[ws].drawArgument1 = 49
GT.WS[ws].drawArgument2 = 50
GT.WS[ws].angles[1][1] = math.rad(170);
GT.WS[ws].angles[1][2] = math.rad(3);
GT.WS[ws].reference_angle_Y = math.rad(175);  
GT.WS[ws].LN[1].fireAnimationArgument = 51;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_13_1',
		recoilArgument = 51,
	},
	{
		connector_name = 'POINT_Flak38_13_2',
		recoilArgument = 51,
	}
}


--14 Right Aft
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_14'
GT.WS[ws].drawArgument1 = 52
GT.WS[ws].drawArgument2 = 53
GT.WS[ws].angles[1][1] = math.rad(-3);
GT.WS[ws].angles[1][2] = math.rad(-170);
GT.WS[ws].reference_angle_Y = math.rad(-180);  
GT.WS[ws].LN[1].fireAnimationArgument = 54;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Flak38_14_1',
		recoilArgument = 54,
	},
	{
		connector_name = 'POINT_Flak38_14_2',
		recoilArgument = 54,
	}
}


------------------------------------------------------------------------
--  21 Mitragliatrici Singole Oerlikon
------------------------------------------------------------------------
--1
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_01'
GT.WS[ws].drawArgument1 = 171
GT.WS[ws].drawArgument2 = 172
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(20);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 72;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_01',
		recoilArgument = 72,
	}
}



--2
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_02'
GT.WS[ws].drawArgument1 = 173
GT.WS[ws].drawArgument2 = 174
GT.WS[ws].angles[1][1] = math.rad(-20);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 74;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_02',
		recoilArgument = 74,
	}
}



--3
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_03'
GT.WS[ws].drawArgument1 = 175
GT.WS[ws].drawArgument2 = 176
GT.WS[ws].angles[1][1] = math.rad(130);
GT.WS[ws].angles[1][2] = math.rad(30);
GT.WS[ws].reference_angle_Y = math.rad(0);  
GT.WS[ws].LN[1].fireAnimationArgument = 76;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_03',
		recoilArgument = 76,
	}
}


--4
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_04'
GT.WS[ws].drawArgument1 = 177
GT.WS[ws].drawArgument2 = 178
GT.WS[ws].angles[1][1] = math.rad(-30);
GT.WS[ws].angles[1][2] = math.rad(-130);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 78;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_04',
		recoilArgument = 78,
	}
}


--5
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_05'
GT.WS[ws].drawArgument1 = 179
GT.WS[ws].drawArgument2 = 180
GT.WS[ws].angles[1][1] = math.rad(30);
GT.WS[ws].angles[1][2] = math.rad(130);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 80;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_05',
		recoilArgument = 80,
	}
}

--6
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_06'
GT.WS[ws].drawArgument1 = 181
GT.WS[ws].drawArgument2 = 182
GT.WS[ws].angles[1][1] = math.rad(-130);
GT.WS[ws].angles[1][2] = math.rad(-30);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 82;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_06',
		recoilArgument = 82,
	}
}

--7
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_07'
GT.WS[ws].drawArgument1 = 183
GT.WS[ws].drawArgument2 = 184
GT.WS[ws].angles[1][1] = math.rad(30);
GT.WS[ws].angles[1][2] = math.rad(100);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 84;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_07',
		recoilArgument = 84,
	}
}


--8
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_08'
GT.WS[ws].drawArgument1 = 185
GT.WS[ws].drawArgument2 = 186
GT.WS[ws].angles[1][1] = math.rad(-100);
GT.WS[ws].angles[1][2] = math.rad(-30);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 86;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_08',
		recoilArgument = 86,
	}
}

--9
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_09'
GT.WS[ws].drawArgument1 = 187
GT.WS[ws].drawArgument2 = 188
GT.WS[ws].angles[1][1] = math.rad(30);
GT.WS[ws].angles[1][2] = math.rad(130);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 88;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_09',
		recoilArgument = 88,
	}
}



--10
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_10'
GT.WS[ws].drawArgument1 = 189
GT.WS[ws].drawArgument2 = 190
GT.WS[ws].angles[1][1] = math.rad(-130);
GT.WS[ws].angles[1][2] = math.rad(-30);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 89;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_10',
		recoilArgument = 89,
	}
}


--11
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_11'
GT.WS[ws].drawArgument1 = 191
GT.WS[ws].drawArgument2 = 192
GT.WS[ws].angles[1][1] = math.rad(30);
GT.WS[ws].angles[1][2] = math.rad(130);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = 91;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_11',
		recoilArgument = 91,
	}
}


--12
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_12'
GT.WS[ws].drawArgument1 = 193
GT.WS[ws].drawArgument2 = 194
GT.WS[ws].angles[1][1] = math.rad(-130);
GT.WS[ws].angles[1][2] = math.rad(-30);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = 93;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_12',
		recoilArgument = 93,
	}
}


--13  --- Gun di poppa centrale
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_13'
GT.WS[ws].drawArgument1 = 220
GT.WS[ws].drawArgument2 = 221
GT.WS[ws].angles[1][1] = math.rad(30);
GT.WS[ws].angles[1][2] = math.rad(-30);
GT.WS[ws].reference_angle_Y = math.rad(180);  
GT.WS[ws].LN[1].fireAnimationArgument = 222;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_13',
		recoilArgument = 222,
	}
}

--14  --- gun di poppa sinistra
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_14'
GT.WS[ws].drawArgument1 = 223
GT.WS[ws].drawArgument2 = 224
GT.WS[ws].angles[1][1] = math.rad(30);
GT.WS[ws].angles[1][2] = math.rad(-30);
GT.WS[ws].reference_angle_Y = math.rad(135);  
GT.WS[ws].LN[1].fireAnimationArgument = 225;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_14',
		recoilArgument = 225,
	}
}

--15  --- gun di poppa destra
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_20_65 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_Oerlikon_15'
GT.WS[ws].drawArgument1 = 226
GT.WS[ws].drawArgument2 = 227
GT.WS[ws].angles[1][1] = math.rad(30);
GT.WS[ws].angles[1][2] = math.rad(-30);
GT.WS[ws].reference_angle_Y = math.rad(135);  
GT.WS[ws].LN[1].fireAnimationArgument = 228;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_20m_15',
		recoilArgument = 228,
	}
}
--16
--17
--18
--19
--20
--21
------------------------------------------------------------------------------------------------
-- 3 Torrette dda 380mm                                                                       --  
--------------  Torretta Cannone di Prua 1 Anton -----------------------------------------------
------------------------------------------------------------------------------------------------
-- Note: Currently can fire up to about 23 km in range with 130 mm shells from default AK130 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_381_50_M1934 )
GT.WS[ws].area = 'Torre_380_Anton' --Torre_380_Anton
GT.WS[ws].center = 'CENTER_TOWER_01'
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1
GT.WS[ws].angles[1][1] = math.rad(140);
GT.WS[ws].angles[1][2] = math.rad(-140);
GT.WS[ws].reference_angle_Y = math.rad(0);	
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_01_1',
		recoilArgument = 33,
	},
	{
		connector_name = 'POINT_Iowa_01_2',
		recoilArgument = 33,
	},
	{
		connector_name = 'POINT_Iowa_01_3',
		recoilArgument = 33,
	}
}


-------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------
-------------  Torretta Cannone di Prua 2 Bruno -------------------------------------------------------------

-- Note: Currently can fire up to about 23 km in range with 130 mm shells from default AK130 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_381_50_M1934 )
GT.WS[ws].area = 'Torre_380_Bruno'
GT.WS[ws].center = 'CENTER_TOWER_02'
GT.WS[ws].drawArgument1 = 13
GT.WS[ws].drawArgument2 = 14
GT.WS[ws].angles[1][1] = math.rad(140);
GT.WS[ws].angles[1][2] = math.rad(-140);
GT.WS[ws].reference_angle_Y = math.rad(0);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_02_1',
		recoilArgument = 34,
	},
	{
		connector_name = 'POINT_Iowa_02_2',
		recoilArgument = 34,
	},
	{
		connector_name = 'POINT_Iowa_02_3',
		recoilArgument = 34,
	}
}

-------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------
--- Torretta Cannone di Poppa  3  Dora ----------------------------------------------------------------------
---   Stern cannon turret
-- Note: Currently can fire up to about 23 km in range with 130 mm shells from default AK130 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_381_50_M1934 )
GT.WS[ws].area = 'Torre_380_Dora' 
GT.WS[ws].center = 'CENTER_TOWER_03'
GT.WS[ws].drawArgument1 = 17
GT.WS[ws].drawArgument2 = 18
GT.WS[ws].reference_angle_Y = math.rad(-180);
GT.WS[ws].angles[1][1] = math.rad(-45);
GT.WS[ws].angles[1][2] = math.rad(45);
--GT.WS[ws].angles = {
--					{math.rad(-45), math.rad(-180), math.rad(2), math.rad(80)},
--					{math.rad(180), math.rad(45), math.rad(2), math.rad(80)},
--}
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_03_1',
		recoilArgument = 35,
	},
	{
		connector_name = 'POINT_Iowa_03_2',
		recoilArgument = 35,
	},
	{
		connector_name = 'POINT_Iowa_03_3',
		recoilArgument = 35,
	}
}



--[[
-----------------------------------------------------------------------------------------------------------
---------- *************** 4 turrets with  3 cannons 150mm   ****************---------------
-----------------------------------------------------------------------------------------------------------

--- Torretta trinata da 150mm Sinistra 1 --------------------------------------------------------------------
-- Note: Currently can fire up to about 23 km in range with 127 mm shells from default FMC5 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Prua_Sx'
GT.WS[ws].center = 'CENTER_TOWER_04'
GT.WS[ws].drawArgument1 = 19
GT.WS[ws].drawArgument2 = 20
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(0);   ----- posizione inziale rispetto all'angolo 0 (+ senso antiorario, - senso orario)
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_RM_MT_1_1',
		recoilArgument = 36,
	},
	{
		connector_name = 'POINT_RM_MT_1_2',
		recoilArgument = 36,
	},
	{
		connector_name = 'POINT_RM_MT_1_3',
		recoilArgument = 36,
	}
}



-----------------------------------------------------------------------------------------------------------
--- Torretta trinata da 150mm Destra  2 --------------------------------------------------------------------
-- Note: Currently can fire up to about 23 km in range with 127 mm shells from default FMC5 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Prua_Dx'
GT.WS[ws].center = 'CENTER_TOWER_05'
GT.WS[ws].drawArgument1 = 21
GT.WS[ws].drawArgument2 = 22
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(0);   ----- posizione inziale rispetto all'angolo 0 (+ senso antiorario, - senso orario)
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_RM_MT_2_1',
		recoilArgument = 37,
	},
	{
		connector_name = 'POINT_RM_MT_2_2',
		recoilArgument = 37,
	},
	{
		connector_name = 'POINT_RM_MT_2_3',
		recoilArgument = 37,
	}
}

----------------------------------------------------------------------------------------------------------------------------------
--- Torretta Binata da 150mm Sinistra 3 --------------------------------------------------------------------------------------
-- Note: Currently can fire up to about 23 km in range with 127 mm shells from default FMC5 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Centrale_Sx'
GT.WS[ws].center = 'CENTER_TOWER_06'
GT.WS[ws].drawArgument1 = 23
GT.WS[ws].drawArgument2 = 24
GT.WS[ws].angles[1][1] = math.rad(179);
GT.WS[ws].angles[1][2] = math.rad(30);
GT.WS[ws].reference_angle_Y = math.rad(-179);   ----- posizione inziale rispetto all'angolo 0 (+ senso antiorario, - senso orario)
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_RM_MT_3_1',
		recoilArgument = 38,
	},
	{
		connector_name = 'POINT_RM_MT_3_2',
		recoilArgument = 38,
	},
	{
		connector_name = 'POINT_RM_MT_3_3',
		recoilArgument = 38,
	}
}

---------------------------------------------------------------------------------------------------------------------
--- Torretta Binata da 150mm Destra 4 --------------------------------------------------------------------------------------

-- Note: Currently can fire up to about 23 km in range with 127 mm shells from default FMC5 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Centrale_Dx'
GT.WS[ws].center = 'CENTER_TOWER_07'
GT.WS[ws].drawArgument1 = 25
GT.WS[ws].drawArgument2 = 26
GT.WS[ws].angles[1][1] = math.rad(-30);
GT.WS[ws].angles[1][2] = math.rad(-179);
GT.WS[ws].reference_angle_Y = math.rad(-179);   ----- posizione inziale rispetto all'angolo 0 (+ senso antiorario, - senso orario)
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_RM_MT_4_1',
		recoilArgument = 39,
	},
	{
		connector_name = 'POINT_RM_MT_4_2',
		recoilArgument = 39,
	},
	{
		connector_name = 'POINT_RM_MT_4_3',
		recoilArgument = 39,
	}
}

--]]
---------------------------------------------------------------------------------------------------------------------------------
---------- ***************   12 turrets 10,5mm   ****************------------------------
---------------------------------------------------------------------------------------------------------------------------------

-----------  naval turrets in the direction of the bow
--- Turret left 1 
-----------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_90_53 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Prua_Sx'
GT.WS[ws].center = 'CENTER_TOWER_105_01'
GT.WS[ws].drawArgument1 = 55
GT.WS[ws].drawArgument2 = 56
GT.WS[ws].angles[1][1] = math.rad(140);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_105_11',
		recoilArgument = 57,
	},
	{
		connector_name = 'POINT_Iowa_105_12',
		recoilArgument = 57,
	}
}


--- Turret right 2
------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_90_53 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Prua_Dx'
GT.WS[ws].center = 'CENTER_TOWER_105_02'
GT.WS[ws].drawArgument1 = 58
GT.WS[ws].drawArgument2 = 59
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(-140);
GT.WS[ws].reference_angle_Y = math.rad(-90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_105_21',
		recoilArgument = 60,
	},
	{
		connector_name = 'POINT_Iowa_105_22',
		recoilArgument = 60,
	}
}


--- Turret Left 3
------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_90_53 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Prua_Sx'
GT.WS[ws].center = 'CENTER_TOWER_105_03'
GT.WS[ws].drawArgument1 = 217
GT.WS[ws].drawArgument2 = 218
GT.WS[ws].angles[1][1] = math.rad(130);
GT.WS[ws].angles[1][2] = math.rad(25);
GT.WS[ws].reference_angle_Y = math.rad(90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_105_31',
		recoilArgument = 219,
	},
	{
		connector_name = 'POINT_Iowa_105_32',
		recoilArgument = 219,
	}
}



--- Turret Right 4
------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_90_53 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Centrale_Dx'
GT.WS[ws].center = 'CENTER_TOWER_105_04'
GT.WS[ws].drawArgument1 = 196
GT.WS[ws].drawArgument2 = 197
GT.WS[ws].angles[1][1] = math.rad(-25);
GT.WS[ws].angles[1][2] = math.rad(-130);
GT.WS[ws].reference_angle_Y = math.rad(-180);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_105_41',
		recoilArgument = 198,
	},
	{
		connector_name = 'POINT_Iowa_105_42',
		recoilArgument = 198,
	}
}


------ naval turrets in the direction of the stern
--- Turret Left 5 
------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_90_53 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Centrale_Sx'
GT.WS[ws].center = 'CENTER_TOWER_105_05'
GT.WS[ws].drawArgument1 = 199
GT.WS[ws].drawArgument2 = 200
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(10);
GT.WS[ws].reference_angle_Y = math.rad(90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_105_51',
		recoilArgument = 201,
	},
	{
		connector_name = 'POINT_Iowa_105_52',
		recoilArgument = 201,
	}
}


--- Turret Right 6
--------------------------------------------------------------------------------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_90_53 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Centrale_Dx'
GT.WS[ws].center = 'CENTER_TOWER_105_06'
GT.WS[ws].drawArgument1 = 202
GT.WS[ws].drawArgument2 = 203
GT.WS[ws].angles[1][1] = math.rad(-10);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_105_61',
		recoilArgument = 204,
	},
	{
		connector_name = 'POINT_Iowa_105_62',
		recoilArgument = 204,
	}
}


--- Turret Left 7
--------------------------------------------------------------------------------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_90_53 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Poppa_Sx'
GT.WS[ws].center = 'CENTER_TOWER_105_07'
GT.WS[ws].drawArgument1 = 205
GT.WS[ws].drawArgument2 = 206
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(35);
GT.WS[ws].reference_angle_Y = math.rad(90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_105_71',
		recoilArgument = 207,
	},
	{
		connector_name = 'POINT_Iowa_105_72',
		recoilArgument = 207,
	}
}



--- Turret Right 8
--------------------------------------------------------------------------------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_90_53 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_105_08'
GT.WS[ws].drawArgument1 = 208
GT.WS[ws].drawArgument2 = 209
GT.WS[ws].angles[1][1] = math.rad(-35);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_105_81',
		recoilArgument = 210,
	},
	{
		connector_name = 'POINT_Iowa_105_82',
		recoilArgument = 210,
	}
}


--- Turret Left 9
--------------------------------------------------------------------------------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_90_53 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_105_09'
GT.WS[ws].drawArgument1 = 211
GT.WS[ws].drawArgument2 = 212
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(40);
GT.WS[ws].reference_angle_Y = math.rad(180);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_105_91',
		recoilArgument = 213,
	},
	{
		connector_name = 'POINT_Iowa_105_92',
		recoilArgument = 213,
	}
}


--- Turret Right 10
--------------------------------------------------------------------------------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_90_53 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_152_55 )
GT.WS[ws].area = 'Scafo_Poppa_Dx'
GT.WS[ws].center = 'CENTER_TOWER_105_10'
GT.WS[ws].drawArgument1 = 214
GT.WS[ws].drawArgument2 = 215
GT.WS[ws].angles[1][1] = math.rad(-40);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-90);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Iowa_105_101',
		recoilArgument = 216,
	},
	{
		connector_name = 'POINT_Iowa_105_102',
		recoilArgument = 216,
	}
}


------------------------------------------------------------------------------------------------------
--      Parte Finale                                                                                --
------------------------------------------------------------------------------------------------------
GT.Name = "missouri"
GT.DisplayName = _("USS Missouri")
GT.Rate = 6000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR",},
                RADAR = {
                "Patriot str",
                "ticonderoga search radar",
                }
            };


			
GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;

GT.Singleton   ="no";
GT.mapclasskey = "P0091000067";
GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,wsType_GenericLightArmoredShip,

                    "Cruisers",
                    "RADAR_BAND1_FOR_ARM",
                    "DetectionByAWACS",
				};
				



GT.Categories = {
					{name = "Armed Ship"},
				};
--GT.Countries = { "ITALY", "Italy", "ITA",};
add_surface_unit(GT)	
			